/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.biome.v1;

import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.jetbrains.annotations.Nullable;

public interface MobSpawnSettingsContext {
    public void setCreatureGenerationProbability(float var1);

    public void addSpawn(MobCategory var1, MobSpawnSettings.SpawnerData var2);

    public boolean removeSpawns(BiPredicate<MobCategory, MobSpawnSettings.SpawnerData> var1);

    default public boolean removeSpawnsOfEntityType(EntityType<?> entityType) {
        return this.removeSpawns((spawnGroup, spawnEntry) -> spawnEntry.f_48404_ == entityType);
    }

    default public void clearSpawns(MobCategory group) {
        this.removeSpawns((spawnGroup, spawnEntry) -> spawnGroup == group);
    }

    default public void clearSpawns() {
        this.removeSpawns((spawnGroup, spawnEntry) -> true);
    }

    public void setSpawnCost(EntityType<?> var1, double var2, double var4);

    public boolean clearSpawnCost(EntityType<?> var1);

    public Set<MobCategory> getMobCategoriesWithSpawns();

    public List<MobSpawnSettings.SpawnerData> getSpawnerData(MobCategory var1);

    public Set<EntityType<?>> getEntityTypesWithSpawnCost();

    @Nullable
    public MobSpawnSettings.MobSpawnCost getSpawnCost(EntityType<?> var1);

    public float getCreatureGenerationProbability();
}

